%Function to calcualate fitted values of the expected futrue short-term
%rates from the JSZ model
%Jonathan Hambur October 2016

function fit_yrf=fit_short(cP,rho0_cP,rho1_cP,K0P_cP,K1P_cP,mats_periods,N,t)

q=size(mats_periods,2);
int_yrf=zeros(t,max(mats_periods));
slope_yrf=zeros(t,max(mats_periods));
int_yrf(:,1)=ones(t,1)*rho0_cP;
slope_yrf(:,1)=cP*rho1_cP;
for i = 2 : max(mats_periods)
    int_yrf(:,i)=int_yrf(:,i-1)+(K0P_cP'*(K1P_cP+eye(N))'^(i-2)*rho1_cP);
    slope_yrf(:,i)=cP*(K1P_cP+eye(N))'^(i-1)*rho1_cP;
end
all_yrf=int_yrf+slope_yrf;

fit_yrf=zeros(t,q);
for i=1:q
    %fit_yrf(:,i)=(1+all_yrf(:,mats_periods(i))).^12-1;
    fit_yrf(:,i)=all_yrf(:,mats_periods(i))*12;

end